/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.hitfeedback.common;

import dev.architectury.networking.NetworkManager;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import mod.chloeprime.hitfeedback.common.HitFeedbackType;
import mod.chloeprime.hitfeedback.common.PlatformMethods;
import mod.chloeprime.hitfeedback.mixin.LivingEntityAccessor;
import mod.chloeprime.hitfeedback.network.ModNetwork;
import mod.chloeprime.hitfeedback.network.S2CHitFeedback;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CommonEventHandler {
    private static final Map<LivingEntity, Long> LAST_SOUND_TIME_TABLE = new WeakHashMap<LivingEntity, Long>();

    public static void onEndAttack(DamageSource source, LivingEntity victim, float amount) {
        float feedbackStrength;
        if (victim.m_9236_().m_5776_()) {
            return;
        }
        Entity attacker = source.m_7639_();
        Entity bullet = source.m_7640_();
        if (attacker == null && bullet == null) {
            return;
        }
        boolean isRangedAttack = bullet != null && bullet != attacker;
        Vec3 position = isRangedAttack ? CommonEventHandler.getBulletHitPosition(bullet, (Entity)victim) : CommonEventHandler.getMeleeHitPosition(attacker, (Entity)victim);
        double velocity = 0.2;
        Vec3 normal = (isRangedAttack ? bullet.m_20184_() : attacker.m_20154_().m_193103_(Direction.Axis.Y, 0.0)).m_82541_().m_82490_(-velocity);
        float maxHealthOfVictim = victim.m_21233_();
        HitFeedbackType feedback = HitFeedbackType.match(source, victim, amount > 0.0f);
        float f = feedbackStrength = maxHealthOfVictim == 0.0f ? 1.0f : Mth.m_14036_((float)(amount / maxHealthOfVictim), (float)0.0f, (float)1.0f);
        if (!feedback.isServerOnly()) {
            S2CHitFeedback packet = new S2CHitFeedback((Entity)victim, feedback, position, normal, feedbackStrength);
            ((ServerLevel)victim.m_9236_()).m_7726_().m_8445_((Entity)victim, ModNetwork.CHANNEL.toPacket(NetworkManager.Side.S2C, (Object)packet));
        }
        if (!CommonEventHandler.acquireHitFeedbackTicket(victim)) {
            return;
        }
        feedback.getHitSound().ifPresent(sound -> {
            float volume = Math.min(1.0f, ((LivingEntityAccessor)victim).invokeGetSoundVolume());
            float pitch = 1.0f + (victim.m_217043_().m_188501_() - victim.m_217043_().m_188501_()) * 0.2f;
            victim.m_5496_(sound, volume, pitch);
        });
    }

    private static boolean acquireHitFeedbackTicket(LivingEntity victim) {
        return Optional.ofNullable(victim.m_20194_()).map(MinecraftServer::m_129783_).filter(overworld -> {
            long now = overworld.m_46467_();
            Long lastHurt = LAST_SOUND_TIME_TABLE.put(victim, now);
            return lastHurt == null || lastHurt < now;
        }).isPresent();
    }

    private static Vec3 getBulletHitPosition(@NotNull Entity bullet, Entity victim) {
        Vec3 ray = bullet.m_20184_();
        if (ray.m_82556_() <= 1.0E-6) {
            return bullet.m_20182_();
        }
        Vec3 start = bullet.m_20182_();
        Vec3 end = start.m_82549_(ray);
        double len = ray.m_82553_();
        AABB aabb = bullet.m_20191_().m_82369_(ray).m_82400_(1.0);
        EntityHitResult hit = ProjectileUtil.m_37287_((Entity)bullet, (Vec3)start, (Vec3)end, (AABB)aabb, entity -> entity == victim, (double)(len * len));
        if (hit != null) {
            return hit.m_82450_();
        }
        Vec3 dir = ray.m_82490_(1.0 / len);
        double ratLength = ray.m_193103_(Direction.Axis.Y, 0.0).m_82553_();
        double groundDistance = victim.m_20182_().m_82546_(bullet.m_20182_()).m_193103_(Direction.Axis.Y, 0.0).m_82553_();
        if (ratLength == 0.0 || groundDistance == 0.0) {
            return victim.m_146892_();
        }
        return bullet.m_20182_().m_82549_(dir.m_82490_(len * groundDistance / ratLength));
    }

    private static Vec3 getMeleeHitPosition(@NotNull Entity swordsman, Entity victim) {
        AABB aabb;
        Vec3 end;
        double reach = PlatformMethods.getAttackReach(swordsman);
        Vec3 ray = swordsman.m_20154_().m_82490_(reach);
        Vec3 start = swordsman.m_146892_();
        EntityHitResult hit = ProjectileUtil.m_37287_((Entity)swordsman, (Vec3)start, (Vec3)(end = start.m_82549_(ray)), (AABB)(aabb = swordsman.m_20191_().m_82369_(ray).m_82400_(1.0)), entity -> entity == victim, (double)(reach * reach));
        if (hit != null) {
            return hit.m_82450_();
        }
        return victim.m_20182_().m_193103_(Direction.Axis.Y, Mth.m_14008_((double)start.f_82480_, (double)victim.m_20186_(), (double)(victim.m_20186_() + (double)victim.m_20206_())));
    }
}

