/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.hitfeedback.client.particles;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import mod.chloeprime.hitfeedback.client.ClientConfig;
import mod.chloeprime.hitfeedback.client.particles.EntityPieceParticle;
import mod.chloeprime.hitfeedback.client.particles.RatedEmitter;
import mod.chloeprime.hitfeedback.mixin.client.TrackingEmitterAccessor;
import mod.chloeprime.hitfeedback.util.Basis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ParticleEmitterBase
extends TrackingEmitter
implements RatedEmitter {
    protected static final Supplier<ParticleEngine> ENGINE = Suppliers.memoize(() -> Minecraft.m_91087_().f_91061_);
    protected final ParticleOptions particle;
    protected final int emitCountPerTick;
    private final float goreSpawnRate;
    private final boolean goreOnly;
    protected Vec3 relPos;
    protected Vec3 relMotion;
    private boolean prepared;
    private final float configRate;
    private float extraConfiguredSpawnRate;

    public ParticleEmitterBase(ParticleOptions particle, Builder builder, Entity entity, ClientLevel clientLevel, double x, double y, double z, double g, double h, double i) {
        super(clientLevel, entity, particle, builder.life);
        float f = ((Double)ClientConfig.PARTICLE_AMOUNT.get()).floatValue();
        this.configRate = f * (switch ((ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()) {
            default -> throw new IncompatibleClassChangeError();
            case ParticleStatus.ALL -> 1.0f;
            case ParticleStatus.DECREASED -> 0.5f;
            case ParticleStatus.MINIMAL -> 0.0f;
        });
        this.extraConfiguredSpawnRate = 1.0f;
        this.particle = particle;
        this.f_107225_ = builder.life;
        this.emitCountPerTick = builder.emitCountPerTick;
        this.goreOnly = builder.goreOnly;
        this.goreSpawnRate = (this.goreOnly ? 1.0f : builder.goreSpawnRate) / EntityPieceParticle.getEntityTexture(entity).map(EntityPieceParticle.EntityTextureInfo::fillRate).orElse(Float.valueOf(1.0f)).floatValue();
        Basis basis = Basis.fromEntityBody(entity);
        this.relPos = basis.toLocal(new Vec3(x, y, z).m_82546_(entity.m_20182_()));
        this.relMotion = basis.toLocal(new Vec3(g, h, i));
        this.prepared = true;
    }

    @Override
    public void setSpawnRate(float rate) {
        this.extraConfiguredSpawnRate = rate;
    }

    public void m_5989_() {
        if (!this.prepared) {
            return;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        Vec3 pos = this.getEmitPos();
        Vec3 vel = this.getEmitVelocity();
        for (int i = 0; i < this.emitCountPerTick; ++i) {
            if (this.goreOnly) {
                float cnt;
                for (cnt = this.goreSpawnRate; cnt >= 1.0f; cnt -= 1.0f) {
                    this.wrapConfigRate(() -> ENGINE.get().m_107344_((Particle)new EntityPieceParticle(((TrackingEmitterAccessor)((Object)this)).getEntity(), this.f_107208_, pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_)));
                }
                if (!(cnt > 0.0f) || !(Math.random() < (double)cnt)) continue;
                this.wrapConfigRate(() -> ENGINE.get().m_107344_((Particle)new EntityPieceParticle(((TrackingEmitterAccessor)((Object)this)).getEntity(), this.f_107208_, pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_)));
                continue;
            }
            this.wrapConfigRate(() -> this.f_107208_.m_7106_(this.particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_));
            if (this.goreSpawnRate <= 0.0f) continue;
            for (int j = 0; j < 4; ++j) {
                if (Math.random() > (double)(this.goreSpawnRate / 4.0f)) continue;
                this.wrapConfigRate(() -> ENGINE.get().m_107344_((Particle)new EntityPieceParticle(((TrackingEmitterAccessor)((Object)this)).getEntity(), this.f_107208_, pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_)));
            }
        }
    }

    private void wrapConfigRate(Runnable action) {
        if (Math.random() <= (double)(this.configRate * this.extraConfiguredSpawnRate)) {
            action.run();
        }
    }

    public Vec3 getEmitPos() {
        Entity boundEntity = ((TrackingEmitterAccessor)((Object)this)).getEntity();
        return boundEntity.m_20182_().m_82549_(Basis.fromEntityBody(boundEntity).toGlobal(this.relPos));
    }

    public Vec3 getEmitVelocity() {
        Entity boundEntity = ((TrackingEmitterAccessor)((Object)this)).getEntity();
        return Basis.fromEntityBody(boundEntity).toGlobal(this.relMotion);
    }

    public static class Builder {
        private int life;
        private int emitCountPerTick;
        private float goreSpawnRate;
        private boolean goreOnly;

        public Builder life(int life) {
            this.life = life;
            return this;
        }

        public Builder emitCountPerTick(int emitCountPerTick) {
            this.emitCountPerTick = emitCountPerTick;
            return this;
        }

        public Builder goreSpawnRate(float rate) {
            this.goreSpawnRate = rate;
            return this;
        }

        public Builder goreOnly() {
            this.goreOnly = true;
            return this;
        }
    }

    public static interface Constructor {
        public TrackingEmitter create(ParticleOptions var1, Builder var2, Entity var3, ClientLevel var4, double var5, double var7, double var9, double var11, double var13, double var15);
    }
}

