/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.hitfeedback.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import mod.chloeprime.hitfeedback.client.MinecraftHolder;
import mod.chloeprime.hitfeedback.client.internal.SizedTexture;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class EntityPieceParticle
extends SingleQuadParticle {
    public static final int SIZE = 4;
    private static final int PACKED_LIGHT_15_15 = LightTexture.m_109885_((int)15, (int)15);
    private final ResourceLocation texture;
    private final boolean valid;
    private final float u0;
    private final float v0;
    private final float u1;
    private final float v1;
    private final boolean illuminate;
    private static final Map<ResourceLocation, BufferRecord> BUFFER_TABLE = new LinkedHashMap<ResourceLocation, BufferRecord>();
    private static PoseStack POSE;

    protected EntityPieceParticle(Entity entity, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.f_107663_ /= 2.0f;
        this.f_107226_ = 1.0f;
        this.f_107225_ += this.f_107223_.m_216339_(40, 100);
        Optional<EntityTextureInfo> tex = EntityPieceParticle.getEntityTexture(entity);
        this.valid = tex.filter(t -> t.width >= 4 && t.height >= 4).isPresent();
        this.texture = this.valid ? tex.get().texture : MissingTextureAtlasSprite.m_118071_();
        int w = this.valid ? tex.get().width : 1;
        int h = this.valid ? tex.get().height : 1;
        this.u0 = this.valid ? (float)this.f_107223_.m_188503_(w - 4 + 1) / (float)w : 0.0f;
        this.v0 = this.valid ? (float)this.f_107223_.m_188503_(h - 4 + 1) / (float)h : 0.0f;
        this.u1 = this.u0 + 4.0f / (float)w;
        this.v1 = this.v0 + 4.0f / (float)h;
        this.illuminate = this.valid && EntityPieceParticle.isIlluminateTexture(tex.get().packedLight, super.m_6355_(MinecraftHolder.getPartialTick()));
    }

    protected int m_6355_(float f) {
        return this.illuminate ? PACKED_LIGHT_15_15 : super.m_6355_(f);
    }

    private static boolean isIlluminateTexture(int rendererPackedLight, int worldPackedLight) {
        int wsl = LightTexture.m_109894_((int)worldPackedLight);
        int wbl = LightTexture.m_109883_((int)worldPackedLight);
        int rsl = LightTexture.m_109894_((int)rendererPackedLight);
        int rbl = LightTexture.m_109883_((int)rendererPackedLight);
        return rsl == 15 && wsl != 15 || rbl == 15 && wbl != 15;
    }

    public static Optional<EntityTextureInfo> getEntityTexture(Entity entity) {
        Optional<EntityRenderer> renderer = Optional.ofNullable(entity).map(arg_0 -> ((EntityRenderDispatcher)MinecraftHolder.MC.m_91290_()).m_114382_(arg_0));
        Optional<ResourceLocation> texture = renderer.map(d -> d.m_5478_(entity));
        if (texture.isEmpty()) {
            return Optional.empty();
        }
        OptionalInt illum = renderer.stream().mapToInt(rd -> rd.m_114505_(entity, MinecraftHolder.getPartialTick())).findAny();
        return texture.map(arg_0 -> ((TextureManager)MinecraftHolder.MC.m_91097_()).m_118506_(arg_0)).map(tex -> {
            SizedTexture simple;
            return tex instanceof SizedTexture ? (simple = (SizedTexture)tex) : null;
        }).map(tex -> new EntityTextureInfo((ResourceLocation)texture.get(), tex.hit_feedback$getWidth(), tex.hit_feedback$getHeight(), tex.hit_feedback$getFillRate(), illum.getAsInt()));
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public static void beforeRender(PoseStack pose) {
        POSE = pose;
    }

    public static void doRender() {
        EntityPieceParticle.withRenderSystemShit(() -> {
            TextureManager texManager = Minecraft.m_91087_().m_91097_();
            BUFFER_TABLE.forEach((texture, rec) -> {
                if (!rec.hasContent) {
                    return;
                }
                rec.hasContent = false;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
                RenderSystem.applyModelViewMatrix();
                ParticleRenderType.f_107433_.m_6505_(rec.tesselator.m_85915_(), texManager);
                rec.tesselator.m_85914_();
            });
        });
        RenderSystem.applyModelViewMatrix();
    }

    private static void withRenderSystemShit(Runnable code) {
        if (POSE == null) {
            return;
        }
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        PoseStack pose = RenderSystem.getModelViewStack();
        pose.m_85836_();
        pose.m_252931_(POSE.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        code.run();
        pose.m_85849_();
    }

    public void m_5744_(VertexConsumer ignored, Camera renderInfo, float partialTicks) {
        if (!this.valid) {
            return;
        }
        BufferRecord data = BUFFER_TABLE.computeIfAbsent(this.texture, tex -> new BufferRecord(new Tesselator(16384)));
        BufferBuilder buffer = data.tesselator.m_85915_();
        if (!data.hasContent) {
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            data.hasContent = true;
        }
        super.m_5744_((VertexConsumer)buffer, renderInfo, partialTicks);
    }

    protected float m_5970_() {
        return this.u0;
    }

    protected float m_5952_() {
        return this.u1;
    }

    protected float m_5951_() {
        return this.v0;
    }

    protected float m_5950_() {
        return this.v1;
    }

    public record EntityTextureInfo(ResourceLocation texture, int width, int height, float fillRate, int packedLight) {
    }

    private static class BufferRecord {
        public final Tesselator tesselator;
        public boolean hasContent;

        private BufferRecord(Tesselator tesselator) {
            this.tesselator = tesselator;
        }
    }
}

