/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.hitfeedback.client;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import mod.chloeprime.hitfeedback.client.HitFeedbackAction;
import mod.chloeprime.hitfeedback.client.particles.GunshotFeedbackEmitter;
import mod.chloeprime.hitfeedback.client.particles.ParticleEmitterBase;
import mod.chloeprime.hitfeedback.client.particles.SwordFeedbackEmitter;
import mod.chloeprime.hitfeedback.common.HitFeedbackType;
import mod.chloeprime.hitfeedback.common.HitFeedbackTypes;
import mod.chloeprime.hitfeedback.common.particle.ModParticleTypes;
import mod.chloeprime.hitfeedback.util.ComparableSupplier;

public class HitFeedbackActions {
    private static final Map<ComparableSupplier<HitFeedbackType>, HitFeedbackAction> registry = new LinkedHashMap<ComparableSupplier<HitFeedbackType>, HitFeedbackAction>();

    private HitFeedbackActions() {
    }

    public static void register(Supplier<HitFeedbackType> type, HitFeedbackAction action) {
        registry.put(new ComparableSupplier<HitFeedbackType>(type), action);
    }

    public static Optional<HitFeedbackAction> get(HitFeedbackType type) {
        ComparableSupplier<HitFeedbackType> key = new ComparableSupplier<HitFeedbackType>(() -> type);
        return Optional.ofNullable(registry.get(key));
    }

    public static void init() {
        HitFeedbackActions.register(HitFeedbackTypes.FLESH_SWORD, HitFeedbackAction.addEmitter(ModParticleTypes.BLOOD, HitFeedbackActions.swordEmitterBuilder().goreSpawnRate(0.25f), SwordFeedbackEmitter::new));
        HitFeedbackActions.register(HitFeedbackTypes.FLESH_GUNSHOT, HitFeedbackAction.addEmitter(ModParticleTypes.BLOOD, HitFeedbackActions.gunshotEmitterBuilder().goreSpawnRate(0.25f), GunshotFeedbackEmitter::new));
        HitFeedbackActions.register(HitFeedbackTypes.BONE, HitFeedbackAction.addEmitter(new ParticleEmitterBase.Builder().life(1).emitCountPerTick(5).goreOnly(), GunshotFeedbackEmitter::new));
        HitFeedbackActions.register(HitFeedbackTypes.METAL, HitFeedbackAction.addEmitter(ModParticleTypes.SPARK, new ParticleEmitterBase.Builder().life(1).emitCountPerTick(10).goreSpawnRate(0.0f), GunshotFeedbackEmitter::new));
        HitFeedbackActions.register(HitFeedbackTypes.SLIME_SWORD, HitFeedbackAction.addEmitter(HitFeedbackActions.swordEmitterBuilder().goreOnly(), SwordFeedbackEmitter::new));
        HitFeedbackActions.register(HitFeedbackTypes.SLIME_GUNSHOT, HitFeedbackAction.addEmitter(HitFeedbackActions.gunshotEmitterBuilder().goreOnly(), GunshotFeedbackEmitter::new));
    }

    public static ParticleEmitterBase.Builder swordEmitterBuilder() {
        return new ParticleEmitterBase.Builder().life(7).emitCountPerTick(5);
    }

    public static ParticleEmitterBase.Builder gunshotEmitterBuilder() {
        return new ParticleEmitterBase.Builder().life(2).emitCountPerTick(8);
    }
}

