/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.hitfeedback.client;

import dev.architectury.networking.NetworkManager;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mod.chloeprime.hitfeedback.client.ClientConfig;
import mod.chloeprime.hitfeedback.client.MinecraftHolder;
import mod.chloeprime.hitfeedback.client.particles.ParticleEmitterBase;
import mod.chloeprime.hitfeedback.client.particles.RatedEmitter;
import mod.chloeprime.hitfeedback.common.particle.ModParticleTypes;
import mod.chloeprime.hitfeedback.mixin.client.ParticleEngineAccessor;
import mod.chloeprime.hitfeedback.network.S2CHitFeedback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

@FunctionalInterface
public interface HitFeedbackAction
extends BiConsumer<S2CHitFeedback, NetworkManager.PacketContext> {
    public static HitFeedbackAction addEmitter(ParticleEmitterBase.Builder builder, ParticleEmitterBase.Constructor constructor) {
        return HitFeedbackAction.addEmitter(ModParticleTypes.BLOOD, builder, constructor);
    }

    public static HitFeedbackAction addEmitter(Supplier<? extends ParticleOptions> particle, ParticleEmitterBase.Builder builder, ParticleEmitterBase.Constructor constructor) {
        return (packet, context) -> {
            if ((Double)ClientConfig.PARTICLE_AMOUNT.get() == 0.0) {
                return;
            }
            if (Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) {
                return;
            }
            Vec3 pos = packet.position;
            Vec3 vel = packet.velocity;
            Entity entity = packet.getEntity(context.getPlayer().m_9236_());
            TrackingEmitter emitter = constructor.create((ParticleOptions)particle.get(), builder, entity, (ClientLevel)entity.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
            if (emitter instanceof RatedEmitter) {
                RatedEmitter rated = (RatedEmitter)emitter;
                float spawnRate = Mth.m_144920_((float)0.2f, (float)1.0f, (float)(4.0f * packet.strength));
                rated.setSpawnRate(spawnRate);
            }
            ((ParticleEngineAccessor)MinecraftHolder.MC.f_91061_).getTrackingEmitters().add(emitter);
        };
    }
}

