/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.config;

import io.github.bumblesoftware.fastload.util.Bound;

public interface DefaultConfig {
    public static final String CHUNK_TRY_LIMIT_KEY = "chunk_try_limit";
    public static final String DEBUG_KEY = "debug";
    public static final String INSTANT_LOAD_KEY = "instant_load";
    public static final String LOCAL_RENDER_KEY = DefaultConfig.renderKey("local");
    public static final String LOCAL_RENDER_RADIUS_KEY = DefaultConfig.suffix(LOCAL_RENDER_KEY, false);
    public static final String LOCAL_RENDER_AREA_KEY = DefaultConfig.suffix(LOCAL_RENDER_KEY, true);
    public static final String SERVER_RENDER_KEY = DefaultConfig.renderKey("server");
    public static final String SERVER_RENDER_RADIUS_KEY = DefaultConfig.suffix(SERVER_RENDER_KEY, false);
    public static final String SERVER_RENDER_AREA_KEY = DefaultConfig.suffix(SERVER_RENDER_KEY, true);
    public static final Bound LOCAL_CHUNK_RADIUS_BOUND = new Bound(32, 0);
    public static final Bound SERVER_CHUNK_RADIUS_BOUND = new Bound(LOCAL_CHUNK_RADIUS_BOUND.max() / 2, LOCAL_CHUNK_RADIUS_BOUND.min());
    public static final Bound CHUNK_TRY_LIMIT_BOUND = new Bound(2500, 1);
    public static final boolean DEF_DEBUG_VALUE = false;
    public static final boolean DEF_INSTANT_LOAD_VALUE = false;
    public static final int DEF_SERVER_RENDER_RADIUS_VALUE = 3;
    public static final int DEF_RENDER_RADIUS_VALUE = 10;
    public static final int DEF_TRY_LIMIT_VALUE = 250;

    private static String renderKey(String env) {
        return env + "_render";
    }

    private static String suffix(String renderType, boolean area) {
        if (!area) {
            return renderType + "_chunk_radius";
        }
        return renderType + "_chunk_area";
    }
}

