/*
 * Decompiled with CFR 0.152.
 */
package cn.chloeprime.aaa_particles_world.client.content;

import cn.chloeprime.aaa_particles_world.AAAParticlesWorldMod;
import cn.chloeprime.aaa_particles_world.client.AAAParticlesWorldClient;
import cn.chloeprime.aaa_particles_world.client.ClientConfig;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import mod.chloeprime.aaaparticles.client.registry.EffectDefinition;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LootBeamEffek {
    public static final ResourceLocation EFFEK_ID = AAAParticlesWorldMod.loc("loot_beam");
    public static final boolean FLOATS_WITH_ITEM = false;

    public static boolean isEnabled() {
        return (Boolean)ClientConfig.ENABLE_LOOT_BEAM.get() != false && AAAParticlesWorldClient.isEffekEnabled();
    }

    public static void playLootBeamEffek(ItemEntity entity) {
        ItemStack item = entity.m_32055_();
        Color color = LootBeamEffek.getColor(item).orElse(null);
        if (color == null) {
            return;
        }
        BakedModel itemModel = Minecraft.m_91087_().m_91291_().m_174264_(item, entity.m_9236_(), null, entity.m_19879_());
        float heightScale = itemModel.m_7442_().m_269404_((ItemDisplayContext)ItemDisplayContext.GROUND).f_111757_.y();
        ResourceLocation effekId = EFFEK_ID;
        ResourceLocation emitter = AAAParticlesWorldMod.loc(String.valueOf(entity.m_19879_()));
        ParticleEmitterInfo pei = ParticleEmitterInfo.create((Level)entity.m_9236_(), (ResourceLocation)effekId, (ResourceLocation)emitter).bindOnEntity((Entity)entity).position(0.0, (double)(0.1125f + 0.25f * (heightScale + 0.5f)), 0.0).parameter(0, (float)color.getRed() / 255.0f).parameter(1, (float)color.getGreen() / 255.0f).parameter(2, (float)color.getBlue() / 255.0f).parameter(3, (float)color.getAlpha() / 255.0f);
        AAALevel.addParticle((Level)entity.m_9236_(), (ParticleEmitterInfo)pei);
    }

    public static Optional<Color> getColor(ItemStack item) {
        Optional name = Optional.ofNullable(Minecraft.m_91087_().f_91074_).stream().flatMap(player -> item.m_41651_((Player)player, (TooltipFlag)TooltipFlag.f_256752_).stream()).findFirst();
        return name.map(LootBeamEffek::getRealColor).filter(color -> !Objects.equals(color, ChatFormatting.WHITE.m_126665_())).map(Color::new);
    }

    @Nullable
    private static Integer getRealColor(Component line) {
        Integer legacy;
        if (ComponentContents.f_237124_.equals(line.m_214077_())) {
            List extra = line.m_7360_();
            if (extra.isEmpty()) {
                return null;
            }
            Integer color = LootBeamEffek.getRealColor((Component)extra.get(0));
            if (color != null) {
                return color;
            }
        }
        if ((legacy = LootBeamEffek.getLegacyFormatColor(line.getString())) != null) {
            return legacy;
        }
        Style style = line.m_7383_();
        return style == Style.f_131099_ ? null : (Integer)Optional.ofNullable(style.m_131135_()).map(TextColor::m_131265_).orElse(null);
    }

    @Nullable
    private static Integer getLegacyFormatColor(String line) {
        boolean isFormat = false;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (ch == '\u00a7') {
                isFormat = true;
                continue;
            }
            if (!isFormat && Character.isWhitespace(ch)) continue;
            if (!isFormat) {
                return null;
            }
            char code = Character.toLowerCase(ch);
            Integer color = Optional.ofNullable(ChatFormatting.m_126645_((char)code)).map(ChatFormatting::m_126665_).orElse(null);
            if (color == null) continue;
            return color;
        }
        return null;
    }

    private static /* synthetic */ void lambda$playLootBeamEffek$2(ItemEntity entity, float heightScale, ParticleEmitter em1) {
        em1.addPreDrawCallback((em, partial) -> {
            if (entity.m_213877_() || !em.exists()) {
                em.stop();
                return;
            }
            float waveHeight = (Mth.m_14031_((float)(((float)entity.m_32059_() + partial) / 10.0f + entity.f_31983_)) + 1.0f) * 0.1f;
            em.setPosition((float)Mth.m_14139_((double)partial, (double)entity.f_19790_, (double)entity.m_20185_()) + 0.0f, (float)Mth.m_14139_((double)partial, (double)entity.f_19791_, (double)entity.m_20186_()) + waveHeight + 0.0125f + 0.25f * (heightScale + 0.5f), (float)Mth.m_14139_((double)partial, (double)entity.f_19792_, (double)entity.m_20189_()) + 0.0f);
        });
    }

    private static /* synthetic */ Optional lambda$playLootBeamEffek$0(ResourceLocation emitter, EffectDefinition effek) {
        return effek.getNamedEmitter(ParticleEmitter.Type.WORLD, emitter);
    }
}

