/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.api.client.effekseer;

import Effekseer.swig.EffekseerEffectCore;
import java.io.IOException;
import java.io.InputStream;
import mod.chloeprime.aaaparticles.api.client.effekseer.SafeFinalized;
import mod.chloeprime.aaaparticles.api.client.effekseer.TextureType;
import mod.chloeprime.aaaparticles.common.util.Helpers;

public class EffekseerEffect
extends SafeFinalized<EffekseerEffectCore> {
    protected final EffekseerEffectCore impl;
    private boolean isLoaded = false;

    public EffekseerEffect() {
        this(Helpers.checkPlatform(EffekseerEffectCore::new));
    }

    @Override
    public void close() {
        this.impl.delete();
    }

    public boolean load(InputStream stream, float amplifier) throws IOException {
        byte[] bytes = stream.readAllBytes();
        return this.load(bytes, bytes.length, amplifier);
    }

    public boolean load(byte[] data, int length, float amplifier) {
        this.isLoaded = this.impl.Load(data, length, amplifier);
        return this.isLoaded;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public boolean loadTexture(InputStream stream, int index, TextureType type) throws IOException {
        byte[] bytes = stream.readAllBytes();
        return this.loadTexture(bytes, bytes.length, index, type);
    }

    public boolean loadTexture(byte[] data, int length, int index, TextureType type) {
        return this.impl.LoadTexture(data, length, index, type.getImpl());
    }

    public boolean loadCurve(InputStream stream, int index) throws IOException {
        byte[] bytes = stream.readAllBytes();
        return this.loadCurve(bytes, bytes.length, index);
    }

    public boolean loadCurve(byte[] data, int length, int index) {
        return this.impl.LoadCurve(data, length, index);
    }

    public boolean loadMaterial(InputStream stream, int index) throws IOException {
        byte[] bytes = stream.readAllBytes();
        return this.loadMaterial(bytes, bytes.length, index);
    }

    public boolean loadMaterial(byte[] data, int length, int index) {
        return this.impl.LoadMaterial(data, length, index);
    }

    public boolean loadModel(InputStream stream, int index) throws IOException {
        byte[] bytes = stream.readAllBytes();
        return this.loadModel(bytes, bytes.length, index);
    }

    public boolean loadModel(byte[] data, int length, int index) {
        return this.impl.LoadModel(data, length, index);
    }

    public boolean isModelLoaded(int index) {
        return this.impl.HasModelLoaded(index);
    }

    public boolean isCurveLoaded(int index) {
        return this.impl.HasCurveLoaded(index);
    }

    public boolean isMaterialLoaded(int index) {
        return this.impl.HasMaterialLoaded(index);
    }

    public boolean isTextureLoaded(int index, TextureType type) {
        return this.impl.HasTextureLoaded(index, type.getImpl());
    }

    public int curveCount() {
        return this.impl.GetCurveCount();
    }

    public int modelCount() {
        return this.impl.GetModelCount();
    }

    public int materialCount() {
        return this.impl.GetMaterialCount();
    }

    public int textureCount(TextureType type) {
        return this.impl.GetTextureCount(type.getImpl());
    }

    public int textureCount() {
        int amt = 0;
        for (TextureType value : TextureType.values()) {
            amt += this.impl.GetTextureCount(value.getImpl());
        }
        return amt;
    }

    public String getTexturePath(int index, TextureType type) {
        return this.impl.GetTexturePath(index, type.getImpl());
    }

    public String getCurvePath(int index) {
        return this.impl.GetCurvePath(index);
    }

    public String getMaterialPath(int index) {
        return this.impl.GetMaterialPath(index);
    }

    public String getModelPath(int index) {
        return this.impl.GetModelPath(index);
    }

    public int minTerm() {
        return this.impl.GetTermMin();
    }

    public int maxTerm() {
        return this.impl.GetTermMax();
    }

    public final EffekseerEffectCore getImpl() {
        return this.impl;
    }

    protected EffekseerEffect(EffekseerEffectCore impl) {
        super(impl, EffekseerEffectCore::delete);
        this.impl = impl;
    }
}

