/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.restraints.custom;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.cap.base.IRestrainableCapability;
import com.lazrproductions.cuffed.entity.animation.ArmRestraintAnimationFlags;
import com.lazrproductions.cuffed.entity.animation.LegRestraintAnimationFlags;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModModelLayers;
import com.lazrproductions.cuffed.init.ModRestraints;
import com.lazrproductions.cuffed.init.ModSounds;
import com.lazrproductions.cuffed.init.ModStatistics;
import com.lazrproductions.cuffed.restraints.base.AbstractArmRestraint;
import com.lazrproductions.cuffed.restraints.base.IBreakableRestraint;
import com.lazrproductions.cuffed.restraints.base.IEnchantableRestraint;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import com.lazrproductions.cuffed.restraints.client.RestraintModelInterface;
import com.lazrproductions.cuffed.restraints.client.model.FuzzyHandcuffsModel;
import com.lazrproductions.lazrslib.client.screen.ScreenUtilities;
import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import com.lazrproductions.lazrslib.client.screen.base.ScreenTexture;
import com.lazrproductions.lazrslib.common.math.MathUtilities;
import com.mojang.blaze3d.platform.Window;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FuzzyHandcuffsRestraint
extends AbstractArmRestraint
implements IBreakableRestraint,
IEnchantableRestraint {
    static final ResourceLocation CUFFED_WIDGETS = new ResourceLocation("cuffed", "textures/gui/widgets.png");
    static final ScreenTexture CHAIN_ICON = new ScreenTexture(CUFFED_WIDGETS, 92.0f, 24.0f, 16, 16, 192, 192);
    public static final ResourceLocation ID = ModRestraints.FUZZY_HANDCUFFS.getId();
    public static final Item ITEM = (Item)ModItems.FUZZY_HANDCUFFS.get();
    public static final Item KEY = (Item)ModItems.HANDCUFFS_KEY.get();
    public static final ArmRestraintAnimationFlags ARM_ANIMATION_FLAGS = ArmRestraintAnimationFlags.ARMS_TIED_BEHIND;
    int lastBarIndex = 0;
    private int durability = 100;
    float breakCooldown = 4.0f;
    int lastKeyPressed = -1;
    ListTag enchantments;

    public FuzzyHandcuffsRestraint() {
        this.enchantments = new ListTag();
    }

    public FuzzyHandcuffsRestraint(ItemStack stack, ServerPlayer player, ServerPlayer captor) {
        super(stack, player, captor);
        this.durability = this.getMaxDurability() - stack.m_41773_();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public String getActionBarLabel() {
        return "info.cuffed.restraints.fuzzy_handcuffs.action_bar";
    }

    @Override
    public String getName() {
        return "info.cuffed.restraints.fuzzy_handcuffs.name";
    }

    @Override
    public Item getItem() {
        return ITEM;
    }

    @Override
    public Item getKeyItem() {
        return KEY;
    }

    @Override
    public ArmRestraintAnimationFlags getArmAnimationFlags() {
        return ARM_ANIMATION_FLAGS;
    }

    @Override
    public LegRestraintAnimationFlags getLegAnimationFlags() {
        return LegRestraintAnimationFlags.NONE;
    }

    @Override
    public SoundEvent getEquipSound() {
        return ModSounds.HANDCUFFED;
    }

    @Override
    public SoundEvent getUnequipSound() {
        return SoundEvents.f_11672_;
    }

    @Override
    public boolean AllowBreakingBlocks() {
        return false;
    }

    @Override
    public boolean AllowItemUse() {
        return false;
    }

    @Override
    public boolean AllowMovement() {
        return true;
    }

    @Override
    public boolean AllowJumping() {
        return true;
    }

    @Override
    public boolean getLockpickable() {
        return (Boolean)CuffedMod.SERVER_CONFIG.FUZZY_HANDCUFFS_ON_ARMS_LOCKPICKABLE.get();
    }

    @Override
    public int getLockpickingProgressPerPick() {
        return (Integer)CuffedMod.SERVER_CONFIG.FUZZY_HANDCUFFS_ON_ARMS_LOCKPICKING_PROGRESS_PER_PICK.get();
    }

    @Override
    public int getLockpickingSpeedIncreasePerPick() {
        return (Integer)CuffedMod.SERVER_CONFIG.FUZZY_HANDCUFFS_ON_ARMS_LOCKPICKING_SPEED_INCREASE_PER_PICK.get();
    }

    @Override
    public void onTickServer(ServerPlayer player) {
        super.onTickServer(player);
    }

    @Override
    public void onTickClient(Player player) {
        super.onTickClient(player);
        if (this.breakCooldown > 0.0f) {
            this.breakCooldown -= 1.0f;
        }
    }

    @Override
    public void onEquippedServer(ServerPlayer player, ServerPlayer captor) {
        super.onEquippedServer(player, captor);
    }

    @Override
    public void onEquippedClient(Player player, Player captor) {
        super.onEquippedClient(player, captor);
    }

    @Override
    public void onUnequippedServer(ServerPlayer player) {
        super.onUnequippedServer(player);
    }

    @Override
    public void onUnequippedClient(Player player) {
        super.onUnequippedClient(player);
    }

    @Override
    public void onLoginServer(ServerPlayer player) {
    }

    @Override
    public void onLoginClient(Player player) {
    }

    @Override
    public void onLogoutServer(ServerPlayer player) {
    }

    @Override
    public void onLogoutClient(Player player) {
    }

    @Override
    public void onDeathServer(ServerPlayer player) {
    }

    @Override
    public void onDeathClient(Player player) {
    }

    @Override
    public void onJumpServer(ServerPlayer player) {
    }

    @Override
    public void onJumpClient(Player player) {
    }

    @Override
    public float onLandServer(ServerPlayer player, float distance, float damageMultiplier) {
        return 1.0f;
    }

    @Override
    public void onLandClient(Player player, float distance, float damageMultiplier) {
    }

    @Override
    public void renderOverlay(Player player, GuiGraphics graphics, float partialTick, Window window) {
        super.renderOverlay(player, graphics, partialTick, window);
        float f = Mth.m_14036_((float)(this.breakCooldown / 10.0f), (float)0.0f, (float)1.0f) + 1.0f;
        graphics.m_280246_(f, f, f, 1.0f);
        int iconWidth = 28;
        int iconHeight = 28;
        int x = window.m_85445_() / 2 - iconWidth / 2;
        int y = window.m_85446_() / 2 - iconHeight - 65;
        ScreenUtilities.drawTexture((GuiGraphics)graphics, (BlitCoordinates)new BlitCoordinates(x, y, iconWidth, iconHeight), (ScreenTexture)CHAIN_ICON);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        float p = Mth.m_14036_((float)((float)this.clientSidedDurability / (float)this.getMaxDurability()), (float)0.0f, (float)1.0f);
        ScreenUtilities.drawGenericProgressBar((GuiGraphics)graphics, (BlitCoordinates)new BlitCoordinates(x, y + iconHeight - 2, iconWidth, iconHeight), (float)p);
    }

    @Override
    public void onKeyInput(Player player, int keyCode, int action) {
        super.onKeyInput(player, keyCode, action);
    }

    @Override
    public void onMouseInput(Player player, int keyCode, int action) {
        super.onMouseInput(player, keyCode, action);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public RestraintModelInterface getModelInterface() {
        return new FuzzyHandcuffsRestraintModelInterface();
    }

    @Override
    public SoundEvent getBreakSound() {
        return SoundEvents.f_12018_;
    }

    @Override
    public boolean isKeyToAttemptBreak(int keyCode, Options options) {
        return keyCode == options.f_92096_.getKey().m_84873_() || keyCode == options.f_92095_.getKey().m_84873_();
    }

    @Override
    public boolean requireAlternateKeysToAttemptBreak() {
        return true;
    }

    @Override
    public int getMaxDurability() {
        return ((Item)ModItems.FUZZY_HANDCUFFS.get()).getMaxDamage(((Item)ModItems.FUZZY_HANDCUFFS.get()).m_7968_());
    }

    @Override
    public boolean dropItemOnBroken() {
        return (Boolean)CuffedMod.SERVER_CONFIG.FUZZY_HANDCUFFS_ON_ARMS_DROP_ITEM_WHEN_BROKEN.get();
    }

    @Override
    public boolean canBeBrokenOutOf() {
        return (Boolean)CuffedMod.SERVER_CONFIG.FUZZY_HANDCUFFS_ON_ARMS_CAN_BE_BROKEN_OUT_OF.get();
    }

    @Override
    public int getDurability() {
        return this.durability;
    }

    @Override
    public void attemptToBreak(Player player, int keyCode, int action, Options options) {
        if (this.breakCooldown <= 0.0f && this.canBeBrokenOutOf() && this.isKeyToAttemptBreak(keyCode, options) && (!this.requireAlternateKeysToAttemptBreak() || keyCode != this.lastKeyPressed)) {
            Random r = new Random();
            double chance = 0.5;
            double cooldownMultiplier = 1.0;
            if (this instanceof IEnchantableRestraint && this.hasEnchantment(Enchantments.f_44986_)) {
                double d = (double)this.getEnchantmentLevel(Enchantments.f_44986_) / 3.0;
                chance = (MathUtilities.invert01((double)(d / 3.0)) * 0.7 + 0.3) * 0.5;
                cooldownMultiplier = 1.0 + d;
            }
            if (r.nextDouble() < chance) {
                this.lastKeyPressed = keyCode;
                player.m_6330_(SoundEvents.f_11746_, SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)player.m_217043_(), (float)0.9f, (float)1.1f));
                CuffedAPI.Networking.sendRestraintUtilityPacketToServer(this.getType(), 102, -1, false, 0.0, "");
                this.breakCooldown = r.nextInt(20) + Mth.m_14107_((double)(20.0 * cooldownMultiplier));
            }
        }
    }

    @Override
    public void setDurability(ServerPlayer player, int value) {
        if (value > this.getMaxDurability()) {
            value = this.getMaxDurability();
        }
        if (value < 0) {
            value = 0;
        }
        this.durability = value;
        CuffedAPI.Networking.sendRestraintUtilityPacketToClient(player, this.getType(), 101, this.durability, false, 0.0, "");
        if (this.durability <= 0) {
            this.onBrokenServer(player);
        }
    }

    @Override
    public void incrementDurability(ServerPlayer player, int value) {
        int newValue = this.getDurability() + value;
        this.setDurability(player, newValue);
    }

    @Override
    public void onBrokenServer(ServerPlayer player) {
        CuffedAPI.Networking.sendRestraintUtilityPacketToClient(player, this.getType(), 103, 0, false, 0.0, "");
        Random random = new Random();
        player.m_9236_().m_5594_(null, player.m_20183_(), this.getBreakSound(), SoundSource.PLAYERS, 0.8f, random.nextFloat() * 0.2f + 0.9f);
        ModStatistics.awardRestraintBroken(player, this);
        if (this.dropItemOnBroken()) {
            ItemStack stack = this.saveToItemStack();
            stack.m_41721_(stack.m_41776_() - 1);
            ItemEntity e = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_() + 0.6, player.m_20189_(), stack);
            e.m_32060_();
            player.m_9236_().m_7967_((Entity)e);
        }
        IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
        if (this.getType() == RestraintType.Arm) {
            cap.setArmRestraintWithoutWarning(player, null);
        } else {
            cap.setLegRestraintWithoutWarning(player, null);
        }
    }

    @Override
    public void onBrokenClient(Player player) {
    }

    @Override
    public ListTag getEnchantments() {
        return this.enchantments;
    }

    @Override
    public void setEnchantments(ListTag tag) {
        this.enchantments = tag;
    }

    @Override
    public boolean hasEnchantment(Enchantment enchantment) {
        ResourceLocation resourcelocation = EnchantmentHelper.m_182432_((Enchantment)enchantment);
        for (int i = 0; i < this.enchantments.size(); ++i) {
            CompoundTag compoundtag = this.enchantments.m_128728_(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantmentLevel(Enchantment enchantment) {
        ResourceLocation resourcelocation = EnchantmentHelper.m_182432_((Enchantment)enchantment);
        for (int i = 0; i < this.enchantments.size(); ++i) {
            CompoundTag compoundtag = this.enchantments.m_128728_(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            return EnchantmentHelper.m_182438_((CompoundTag)compoundtag);
        }
        return 0;
    }

    @Override
    public void enchant(Enchantment enchantment, int value) {
        ResourceLocation l = EnchantmentHelper.m_182432_((Enchantment)enchantment);
        this.enchantments.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)l, (int)value));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FuzzyHandcuffsRestraintModelInterface
    extends RestraintModelInterface {
        static final Class<? extends HumanoidModel<? extends LivingEntity>> MODEL_CLASS = FuzzyHandcuffsModel.class;
        static final ModelLayerLocation MODEL_LAYER = ModModelLayers.FUZZY_HANDCUFFS_LAYER;
        static final ResourceLocation MODEL_TEXTURE = new ResourceLocation("cuffed", "textures/entity/fuzzy_handcuffs.png");

        @Override
        public Class<? extends HumanoidModel<? extends LivingEntity>> getRenderedModel() {
            return MODEL_CLASS;
        }

        @Override
        public ModelLayerLocation getRenderedModelLayer() {
            return MODEL_LAYER;
        }

        @Override
        public ResourceLocation getRenderedModelTexture() {
            return MODEL_TEXTURE;
        }
    }
}

