/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigurationClientPacket;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.tree.CheckTree;

public class ClientSyncGuiLayer
extends GuiLayer {
    public final CheckTree<ConfigKey> tree;
    public final ICreativeConfigHolder root;
    public CheckTree.CheckTreeEntry currentView;
    public boolean changed = false;
    public int nextAction;
    public boolean force;

    public ClientSyncGuiLayer(ICreativeConfigHolder holder) {
        super("client-sync", 300, 200);
        this.root = holder;
        this.flow = GuiFlow.STACK_Y;
        this.registerEvent(GuiControlChangedEvent.class, x -> {
            this.changed = true;
            if (x.control instanceof GuiTreeCheckBox && !((GuiTreeCheckBox)x.control).value) {
                ((GuiTreeCheckBox)x.control).partial = ((GuiTreeCheckBox)x.control).entry.isChildEnabled();
            }
        });
        BiConsumer<ConfigKey, Boolean> setter = (x, y) -> {
            x.forceSynchronization = y;
        };
        Function<ConfigKey, Boolean> getter = x -> x.forceSynchronization;
        Function<ConfigKey, Collection> getChildren = x -> {
            Object patt2878$temp = x.getDefault();
            if (patt2878$temp instanceof ICreativeConfigHolder) {
                ICreativeConfigHolder configHolder = (ICreativeConfigHolder)patt2878$temp;
                ArrayList<ConfigKey> keys = new ArrayList<ConfigKey>();
                for (ConfigKey configKey : configHolder.fields()) {
                    ICreativeConfigHolder objectHolder;
                    Object patt3120$temp;
                    if (!configKey.isWithoutForce(Side.CLIENT) || (patt3120$temp = configKey.get()) instanceof ICreativeConfigHolder && (objectHolder = (ICreativeConfigHolder)patt3120$temp).isEmptyWithoutForce(Side.CLIENT)) continue;
                    keys.add(configKey);
                }
                return keys;
            }
            return null;
        };
        ArrayList<ConfigKey> keys = new ArrayList<ConfigKey>();
        for (ConfigKey configKey : holder.fields()) {
            ICreativeConfigHolder configHolder;
            Object object;
            if (!configKey.isWithoutForce(Side.CLIENT) || (object = configKey.get()) instanceof ICreativeConfigHolder && (configHolder = (ICreativeConfigHolder)object).isEmptyWithoutForce(Side.CLIENT)) continue;
            keys.add(configKey);
        }
        this.tree = new CheckTree<ConfigKey>(keys, setter, getter, getChildren);
        this.currentView = this.tree.root;
    }

    @Override
    public void create() {
        this.load(this.currentView);
    }

    public void save() {
        this.getIntegratedParent().send(new ConfigurationClientPacket(this.root, this.tree));
    }

    public void load(CheckTree.CheckTreeEntry entry) {
        if (!this.isEmpty()) {
            this.clear();
        }
        ICreativeConfigHolder holder = entry.content == null ? this.root : (ICreativeConfigHolder)((ConfigKey)entry.content).get();
        this.add((GuiControl)new GuiLeftRightBox().addLeft(new GuiLabel("path").setTitle((Component)Component.m_237113_((String)("/" + String.join((CharSequence)"/", holder.path()))))).addRight(new GuiButton("back", x -> this.load(entry.parent)).setTranslate("gui.back").setEnabled(entry.parent != null)));
        this.currentView = entry;
        GuiScrollY box = new GuiScrollY("").setExpandable().setDim(100, 100);
        this.add((GuiControl)box);
        for (CheckTree.CheckTreeEntry key : this.currentView.children) {
            GuiRow row = new GuiRow();
            box.add((GuiControl)row);
            GuiColumn first = new GuiColumn(20);
            row.addColumn(first);
            first.setVAlign(VAlign.CENTER);
            first.setAlign(Align.CENTER);
            first.add((GuiControl)new GuiTreeCheckBox(key));
            GuiColumn second = (GuiColumn)new GuiColumn().setExpandableX();
            row.addColumn(second);
            String caption = ClientSyncGuiLayer.translateOrDefault("config." + String.join((CharSequence)".", holder.path()) + "." + ((ConfigKey)key.content).name + ".name", ((ConfigKey)key.content).name);
            String comment = "config." + String.join((CharSequence)".", holder.path()) + "." + ((ConfigKey)key.content).name + ".comment";
            if (((ConfigKey)key.content).get() instanceof ICreativeConfigHolder) {
                second.add(new GuiButton(caption, x -> this.load(key)).setTitle((Component)Component.m_237113_((String)caption)).setTooltip(new TextBuilder().translateIfCan(comment).build()));
                continue;
            }
            second.add(new GuiLabel(caption).setTitle((Component)Component.m_237113_((String)caption)).setTooltip(new TextBuilder().translateIfCan(comment).build()));
        }
        this.add((GuiControl)new GuiLeftRightBox().addLeft(new GuiButton("cancel", x -> {
            this.nextAction = 0;
            this.closeTopLayer();
        }).setTranslate("gui.cancel")).addLeft(new GuiButton("config", x -> {
            this.nextAction = 1;
            this.closeTopLayer();
        }).setTranslate("gui.config")).addRight(new GuiButton("save", x -> {
            this.nextAction = 0;
            this.force = true;
            this.save();
            this.closeTopLayer();
        }).setTitle((Component)Component.m_237115_((String)"gui.save"))));
        this.reinit();
    }

    @Override
    public void closeTopLayer() {
        if (this.force || !this.changed) {
            if (this.nextAction == 0) {
                super.closeTopLayer();
            } else if (this.nextAction == 1) {
                CreativeCore.CONFIG_OPEN.open(this.getPlayer());
            }
        } else {
            GuiDialogHandler.openDialog(this.getIntegratedParent(), "savechanges", (x, y) -> {
                if (y == DialogGuiLayer.DialogButton.YES) {
                    this.save();
                }
                if (y != DialogGuiLayer.DialogButton.CANCEL) {
                    this.force = true;
                    this.closeTopLayer();
                }
            }, DialogGuiLayer.DialogButton.YES, DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.CANCEL);
        }
    }

    public static class GuiTreeCheckBox
    extends GuiCheckBox {
        public final CheckTree.CheckTreeEntry entry;

        public GuiTreeCheckBox(CheckTree.CheckTreeEntry entry) {
            super(((ConfigKey)entry.content).name, entry.isEnabled());
            this.entry = entry;
            if (!this.value) {
                this.partial = entry.isChildEnabled();
            }
        }

        @Override
        public boolean mouseClicked(Rect rect, double x, double y, int button) {
            GuiTreeCheckBox.playSound((Holder.Reference<SoundEvent>)SoundEvents.f_12490_);
            boolean bl = this.value = !this.value;
            if (this.value) {
                this.entry.enable();
            } else {
                this.entry.disable();
            }
            this.raiseEvent(new GuiControlChangedEvent<GuiTreeCheckBox>(this));
            return true;
        }
    }
}

