/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.authlib.minecraft.BanDetails;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.gui.screens.RealmsNotificationsScreen;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.CreditsAndAttributionScreen;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.SafetyScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.client.gui.TitleScreenModUpdateIndicator;
import net.minecraftforge.internal.BrandingControl;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TitleScreen
extends Screen {
    private static final Logger f_96717_ = LogUtils.getLogger();
    private static final String f_169439_ = "Demo_World";
    public static final Component f_169438_ = Component.m_237113_((String)"Copyright Mojang AB. Do not distribute!");
    public static final CubeMap f_96716_ = new CubeMap(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation f_96718_ = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    @Nullable
    private SplashRenderer f_96721_;
    private Button f_96722_;
    @Nullable
    private RealmsNotificationsScreen f_96726_;
    private final PanoramaRenderer f_96729_ = new PanoramaRenderer(f_96716_);
    private final boolean f_96714_;
    private long f_96715_;
    @Nullable
    private WarningLabel f_232768_;
    private final LogoRenderer f_263781_;
    private TitleScreenModUpdateIndicator modUpdateNotification;

    public TitleScreen() {
        this(false);
    }

    public TitleScreen(boolean p_96733_) {
        this(p_96733_, null);
    }

    public TitleScreen(boolean p_265779_, @Nullable LogoRenderer p_265067_) {
        super((Component)Component.m_237115_((String)"narrator.screen.title"));
        this.f_96714_ = p_265779_;
        this.f_263781_ = Objects.requireNonNullElseGet(p_265067_, () -> new LogoRenderer(false));
    }

    private boolean m_96789_() {
        return this.f_96726_ != null;
    }

    @Override
    public void m_86600_() {
        if (this.m_96789_()) {
            this.f_96726_.m_86600_();
        }
        this.f_96541_.m_231416_().m_232208_((Screen)this);
    }

    public static CompletableFuture<Void> m_96754_(TextureManager p_96755_, Executor p_96756_) {
        return CompletableFuture.allOf(p_96755_.m_118501_(LogoRenderer.f_263712_, p_96756_), p_96755_.m_118501_(LogoRenderer.f_263806_, p_96756_), p_96755_.m_118501_(f_96718_, p_96756_), f_96716_.m_108854_(p_96755_, p_96756_));
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    @Override
    public boolean m_6913_() {
        return false;
    }

    @Override
    protected void m_7856_() {
        if (this.f_96721_ == null) {
            this.f_96721_ = this.f_96541_.m_91310_().m_280369_();
        }
        int i = this.f_96547_.m_92852_((FormattedText)f_169438_);
        int j = this.f_96543_ - i - 2;
        int k = 24;
        int l = this.f_96544_ / 4 + 48;
        Button modButton = null;
        if (this.f_96541_.m_91402_()) {
            this.m_96772_(l, 24);
        } else {
            this.m_96763_(l, 24);
            modButton = this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"fml.menu.mods"), p_280830_ -> this.f_96541_.m_91152_((Screen)new ModListScreen((Screen)this))).m_252794_(this.f_96543_ / 2 - 100, l + 48).m_253046_(98, 20).m_253136_());
        }
        this.modUpdateNotification = TitleScreenModUpdateIndicator.init((TitleScreen)this, modButton);
        this.m_142416_(new ImageButton(this.f_96543_ / 2 - 124, l + 72 + 12, 20, 20, 0, 106, 20, Button.f_93617_, 256, 256, p_280838_ -> this.f_96541_.m_91152_((Screen)new LanguageSelectScreen((Screen)this, this.f_96541_.f_91066_, this.f_96541_.m_91102_())), (Component)Component.m_237115_((String)"narrator.button.language")));
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"menu.options"), p_280831_ -> this.f_96541_.m_91152_(new OptionsScreen(this, this.f_96541_.f_91066_))).m_252987_(this.f_96543_ / 2 - 100, l + 72 + 12, 98, 20).m_253136_());
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"menu.quit"), p_280835_ -> this.f_96541_.m_91395_()).m_252987_(this.f_96543_ / 2 + 2, l + 72 + 12, 98, 20).m_253136_());
        this.m_142416_(new ImageButton(this.f_96543_ / 2 + 104, l + 72 + 12, 20, 20, 0, 0, 20, Button.f_267372_, 32, 64, p_280834_ -> this.f_96541_.m_91152_((Screen)new AccessibilityOptionsScreen((Screen)this, this.f_96541_.f_91066_)), (Component)Component.m_237115_((String)"narrator.button.accessibility")));
        this.m_142416_(new PlainTextButton(j, this.f_96544_ - 10, i, 10, f_169438_, p_280834_ -> this.f_96541_.m_91152_((Screen)new CreditsAndAttributionScreen((Screen)this)), this.f_96547_));
        this.f_96541_.m_91372_(false);
        if (this.f_96726_ == null) {
            this.f_96726_ = new RealmsNotificationsScreen();
        }
        if (this.m_96789_()) {
            this.f_96726_.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
        if (!this.f_96541_.m_91103_()) {
            this.f_232768_ = new WarningLabel(this.f_96547_, MultiLineLabel.m_94345_((Font)this.f_96547_, (FormattedText)Component.m_237115_((String)"title.32bit.deprecation"), (int)350, (int)2), this.f_96543_ / 2, l - 24);
        }
    }

    private void m_96763_(int p_96764_, int p_96765_) {
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"menu.singleplayer"), p_280833_ -> this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this))).m_252987_(this.f_96543_ / 2 - 100, p_96764_, 200, 20).m_253136_());
        Component component = this.m_240255_();
        boolean flag = component == null;
        Tooltip tooltip = component != null ? Tooltip.m_257550_((Component)component) : null;
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"menu.multiplayer"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, m_210871_(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((TitleScreen)this)).m_252987_((int)(this.f_96543_ / 2 - 100), (int)(p_96764_ + p_96765_ * 1), (int)200, (int)20).m_257505_((Tooltip)tooltip).m_253136_()).f_93623_ = flag;
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"menu.online"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$createNormalMenuOptions$9(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((TitleScreen)this)).m_252987_((int)(this.f_96543_ / 2 + 2), (int)(p_96764_ + p_96765_ * 2), (int)98, (int)20).m_257505_((Tooltip)tooltip).m_253136_()).f_93623_ = flag;
    }

    @Nullable
    private Component m_240255_() {
        if (this.f_96541_.m_91400_()) {
            return null;
        }
        BanDetails bandetails = this.f_96541_.m_239210_();
        if (bandetails != null) {
            return bandetails.expires() != null ? Component.m_237115_((String)"title.multiplayer.disabled.banned.temporary") : Component.m_237115_((String)"title.multiplayer.disabled.banned.permanent");
        }
        return Component.m_237115_((String)"title.multiplayer.disabled");
    }

    private void m_96772_(int p_96773_, int p_96774_) {
        boolean flag = this.m_96792_();
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"menu.playdemo"), p_280837_ -> {
            if (flag) {
                this.f_96541_.m_231466_().m_233133_(this, f_169439_);
            } else {
                this.f_96541_.m_231466_().m_233157_(f_169439_, MinecraftServer.f_129743_, WorldOptions.f_244225_, WorldPresets::m_246552_);
            }
        }).m_252987_(this.f_96543_ / 2 - 100, p_96773_, 200, 20).m_253136_());
        this.f_96722_ = this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"menu.resetdemo"), p_232770_ -> {
            LevelStorageSource levelstoragesource = this.f_96541_.m_91392_();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.m_78260_(f_169439_);){
                LevelSummary levelsummary = levelstoragesource$levelstorageaccess.m_78308_();
                if (levelsummary != null) {
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(this::m_96777_, (Component)Component.m_237115_((String)"selectWorld.deleteQuestion"), (Component)Component.m_237110_((String)"selectWorld.deleteWarning", (Object[])new Object[]{levelsummary.m_78361_()}), (Component)Component.m_237115_((String)"selectWorld.deleteButton"), CommonComponents.f_130656_));
                }
            }
            catch (IOException ioexception) {
                SystemToast.m_94852_((Minecraft)this.f_96541_, (String)f_169439_);
                f_96717_.warn("Failed to access demo world", (Throwable)ioexception);
            }
        }).m_252987_(this.f_96543_ / 2 - 100, p_96773_ + p_96774_ * 1, 200, 20).m_253136_());
        this.f_96722_.f_93623_ = flag;
    }

    private boolean m_96792_() {
        try {
            boolean flag;
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.f_96541_.m_91392_().m_78260_(f_169439_);){
                flag = levelstoragesource$levelstorageaccess.m_78308_() != null;
            }
            return flag;
        }
        catch (IOException ioexception) {
            SystemToast.m_94852_((Minecraft)this.f_96541_, (String)f_169439_);
            f_96717_.warn("Failed to read demo world data", (Throwable)ioexception);
            return false;
        }
    }

    private void m_96793_() {
        this.f_96541_.m_91152_((Screen)new RealmsMainScreen((Screen)this));
    }

    @Override
    public void m_88315_(GuiGraphics p_282860_, int p_281753_, int p_283539_, float p_282628_) {
        if (this.f_96715_ == 0L && this.f_96714_) {
            this.f_96715_ = Util.m_137550_();
        }
        float f = this.f_96714_ ? (float)(Util.m_137550_() - this.f_96715_) / 1000.0f : 1.0f;
        this.f_96729_.m_110003_(p_282628_, Mth.m_14036_((float)f, (float)0.0f, (float)1.0f));
        RenderSystem.enableBlend();
        p_282860_.m_280246_(1.0f, 1.0f, 1.0f, this.f_96714_ ? (float)Mth.m_14167_((float)Mth.m_14036_((float)f, (float)0.0f, (float)1.0f)) : 1.0f);
        p_282860_.m_280411_(f_96718_, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 16, 128, 16, 128);
        p_282860_.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        float f1 = this.f_96714_ ? Mth.m_14036_((float)(f - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        this.f_263781_.m_280037_(p_282860_, this.f_96543_, f1);
        int i = Mth.m_14167_((float)(f1 * 255.0f)) << 24;
        if ((i & 0xFC000000) != 0) {
            if (this.f_232768_ != null) {
                this.f_232768_.m_280409_(p_282860_, i);
            }
            ForgeHooksClient.renderMainMenu((TitleScreen)this, (GuiGraphics)p_282860_, (Font)this.f_96547_, (int)this.f_96543_, (int)this.f_96544_, (int)i);
            if (this.f_96721_ != null) {
                this.f_96721_.m_280672_(p_282860_, this.f_96543_, this.f_96547_, i);
            }
            String s = "Minecraft " + SharedConstants.m_183709_().m_132493_();
            s = this.f_96541_.m_91402_() ? s + " Demo" : s + (String)("release".equalsIgnoreCase(this.f_96541_.m_91389_()) ? "" : "/" + this.f_96541_.m_91389_());
            if (Minecraft.m_193589_().m_184597_()) {
                s = s + I18n.m_118938_("menu.modded", new Object[0]);
            }
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> p_282860_.m_280488_(this.f_96547_, (String)brd, 2, this.f_96544_ - (10 + brdline * (this.f_96547_.f_92710_ + 1)), 0xFFFFFF | i));
            BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> p_282860_.m_280488_(this.f_96547_, (String)brd, this.f_96543_ - this.f_96547_.m_92895_((String)brd), this.f_96544_ - (10 + (brdline + 1) * (this.f_96547_.f_92710_ + 1)), 0xFFFFFF | i));
            for (GuiEventListener guiEventListener : this.m_6702_()) {
                if (!(guiEventListener instanceof AbstractWidget)) continue;
                ((AbstractWidget)guiEventListener).m_93650_(f1);
            }
            super.m_88315_(p_282860_, p_281753_, p_283539_, p_282628_);
            if (this.m_96789_() && f1 >= 1.0f) {
                RenderSystem.enableDepthTest();
                this.f_96726_.m_88315_(p_282860_, p_281753_, p_283539_, p_282628_);
            }
            if (f1 >= 1.0f) {
                this.modUpdateNotification.m_88315_(p_282860_, p_281753_, p_283539_, p_282628_);
            }
        }
    }

    public boolean m_6375_(double p_96735_, double p_96736_, int p_96737_) {
        if (super.m_6375_(p_96735_, p_96736_, p_96737_)) {
            return true;
        }
        return this.m_96789_() && this.f_96726_.m_6375_(p_96735_, p_96736_, p_96737_);
    }

    @Override
    public void m_7861_() {
        if (this.f_96726_ != null) {
            this.f_96726_.m_7861_();
        }
    }

    @Override
    public void m_274333_() {
        super.m_274333_();
        if (this.f_96726_ != null) {
            this.f_96726_.m_274333_();
        }
    }

    private void m_96777_(boolean p_96778_) {
        if (p_96778_) {
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.f_96541_.m_91392_().m_78260_(f_169439_);){
                levelstoragesource$levelstorageaccess.m_78311_();
            }
            catch (IOException ioexception) {
                SystemToast.m_94866_((Minecraft)this.f_96541_, (String)f_169439_);
                f_96717_.warn("Failed to delete demo world", (Throwable)ioexception);
            }
        }
        this.f_96541_.m_91152_(this);
    }

    private /* synthetic */ void lambda$createNormalMenuOptions$9(Button p_210872_) {
        this.m_96793_();
    }

    private /* synthetic */ void m_210871_(Button p_210872_) {
        JoinMultiplayerScreen screen = this.f_96541_.f_91066_.f_92083_ ? new JoinMultiplayerScreen(this) : new SafetyScreen((Screen)this);
        this.f_96541_.m_91152_(screen);
    }

    @OnlyIn(value=Dist.CLIENT)
    record WarningLabel(Font f_232780_, MultiLineLabel f_232781_, int f_232782_, int f_232783_) {
        public void m_280409_(GuiGraphics p_281783_, int p_281383_) {
            this.f_232781_.m_207298_(p_281783_, this.f_232782_, this.f_232783_, 9, 2, 0x200000 | Math.min(p_281383_, 0x55000000));
            this.f_232781_.m_6514_(p_281783_, this.f_232782_, this.f_232783_, 9, 0xFFFFFF | p_281383_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{WarningLabel.class, "font;label;x;y", "f_232780_", "f_232781_", "f_232782_", "f_232783_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WarningLabel.class, "font;label;x;y", "f_232780_", "f_232781_", "f_232782_", "f_232783_"}, this);
        }

        @Override
        public final boolean equals(Object p_232797_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WarningLabel.class, "font;label;x;y", "f_232780_", "f_232781_", "f_232782_", "f_232783_"}, this, p_232797_);
        }
    }
}

