/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.slf4j.Logger;

public class VanillaPackResources
implements PackResources {
    private static final Logger f_10315_ = LogUtils.getLogger();
    private final BuiltInMetadata f_243789_;
    private final Set<String> f_10314_;
    private final List<Path> f_244169_;
    private final Map<PackType, List<Path>> f_244459_;

    VanillaPackResources(BuiltInMetadata p_249743_, Set<String> p_250468_, List<Path> p_248798_, Map<PackType, List<Path>> p_251106_) {
        this.f_243789_ = p_249743_;
        this.f_10314_ = p_250468_;
        this.f_244169_ = p_248798_;
        this.f_244459_ = p_251106_;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... p_250530_) {
        FileUtil.m_245411_(p_250530_);
        List<String> $$1 = List.of(p_250530_);
        for (Path $$2 : this.f_244169_) {
            Path $$3 = FileUtil.m_245247_($$2, $$1);
            if (!Files.exists($$3, new LinkOption[0]) || !PathPackResources.m_246877_($$3)) continue;
            return IoSupplier.m_246697_($$3);
        }
        return null;
    }

    public void m_245163_(PackType p_252103_, ResourceLocation p_250441_, Consumer<Path> p_251968_) {
        FileUtil.m_245538_(p_250441_.m_135815_()).get().ifLeft(p_248238_ -> {
            String $$4 = p_250441_.m_135827_();
            for (Path $$5 : this.f_244459_.get((Object)p_252103_)) {
                Path $$6 = $$5.resolve($$4);
                p_251968_.accept(FileUtil.m_245247_($$6, p_248238_));
            }
        }).ifRight(p_248232_ -> f_10315_.error("Invalid path {}: {}", (Object)p_250441_, (Object)p_248232_.message()));
    }

    @Override
    public void m_8031_(PackType p_248974_, String p_248703_, String p_250848_, PackResources.ResourceOutput p_249668_) {
        FileUtil.m_245538_(p_250848_).get().ifLeft(p_248228_ -> {
            List<Path> $$4 = this.f_244459_.get((Object)p_248974_);
            int $$5 = $$4.size();
            if ($$5 == 1) {
                VanillaPackResources.m_246310_(p_249668_, p_248703_, $$4.get(0), p_248228_);
            } else if ($$5 > 1) {
                HashMap<ResourceLocation, IoSupplier<InputStream>> $$6 = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
                for (int $$7 = 0; $$7 < $$5 - 1; ++$$7) {
                    VanillaPackResources.m_246310_($$6::putIfAbsent, p_248703_, $$4.get($$7), p_248228_);
                }
                Path $$8 = $$4.get($$5 - 1);
                if ($$6.isEmpty()) {
                    VanillaPackResources.m_246310_(p_249668_, p_248703_, $$8, p_248228_);
                } else {
                    VanillaPackResources.m_246310_($$6::putIfAbsent, p_248703_, $$8, p_248228_);
                    $$6.forEach(p_249668_);
                }
            }
        }).ifRight(p_248234_ -> f_10315_.error("Invalid path {}: {}", (Object)p_250848_, (Object)p_248234_.message()));
    }

    private static void m_246310_(PackResources.ResourceOutput p_249662_, String p_251249_, Path p_251290_, List<String> p_250451_) {
        Path $$4 = p_251290_.resolve(p_251249_);
        PathPackResources.m_246914_(p_251249_, $$4, p_250451_, p_249662_);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType p_250512_, ResourceLocation p_251554_) {
        return (IoSupplier)FileUtil.m_245538_(p_251554_.m_135815_()).get().map(p_248224_ -> {
            String $$3 = p_251554_.m_135827_();
            for (Path $$4 : this.f_244459_.get((Object)p_250512_)) {
                Path $$5 = FileUtil.m_245247_($$4.resolve($$3), p_248224_);
                if (!Files.exists($$5, new LinkOption[0]) || !PathPackResources.m_246877_($$5)) continue;
                return IoSupplier.m_246697_($$5);
            }
            return null;
        }, p_248230_ -> {
            f_10315_.error("Invalid path {}: {}", (Object)p_251554_, (Object)p_248230_.message());
            return null;
        });
    }

    @Override
    public Set<String> m_5698_(PackType p_10322_) {
        return this.f_10314_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> p_10333_) {
        IoSupplier<InputStream> $$1 = this.m_8017_("pack.mcmeta");
        if ($$1 == null) return this.f_243789_.m_245920_(p_10333_);
        try (InputStream $$2 = $$1.m_247737_();){
            T $$3 = AbstractPackResources.m_10214_(p_10333_, $$2);
            if ($$3 == null) return this.f_243789_.m_245920_(p_10333_);
            T t = $$3;
            return t;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.f_243789_.m_245920_(p_10333_);
    }

    @Override
    public String m_5542_() {
        return "vanilla";
    }

    @Override
    public boolean m_246538_() {
        return true;
    }

    @Override
    public void close() {
    }

    public ResourceProvider m_215363_() {
        return p_248239_ -> Optional.ofNullable(this.m_214146_(PackType.CLIENT_RESOURCES, p_248239_)).map(p_248221_ -> new Resource(this, (IoSupplier<InputStream>)p_248221_));
    }
}

