/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper$Level;
import pro.gravit.utils.helper.LogHelper$Output;
import pro.gravit.utils.helper.LogHelper$OutputEnity;
import pro.gravit.utils.helper.LogHelper$OutputTypes;
import pro.gravit.utils.logging.LogHelperAppender;
import pro.gravit.utils.logging.SimpleLogHelperImpl;
import pro.gravit.utils.logging.SimpleLogHelperImpl$WriterOutput;
import pro.gravit.utils.logging.Slf4jLogHelperImpl;

public final class LogHelper {
    public static final String DEBUG_PROPERTY = "launcher.debug";
    public static final String DEV_PROPERTY = "launcher.dev";
    public static final String STACKTRACE_PROPERTY = "launcher.stacktrace";
    public static final String NO_JANSI_PROPERTY = "launcher.noJAnsi";
    public static final String SLF4J_PROPERTY = "launcher.useSlf4j";
    private static final Set<Consumer<Throwable>> EXCEPTIONS_CALLBACKS = Collections.newSetFromMap(new ConcurrentHashMap(2));
    private static final LogHelperAppender impl;

    private LogHelper() {
    }

    public static void addOutput(LogHelper$OutputEnity logHelper$OutputEnity) {
        impl.addOutput(logHelper$OutputEnity);
    }

    public static void addExcCallback(Consumer<Throwable> consumer) {
        EXCEPTIONS_CALLBACKS.add(Objects.requireNonNull(consumer, "output"));
    }

    public static void addOutput(LogHelper$Output logHelper$Output, LogHelper$OutputTypes outputTypes) {
        LogHelper.addOutput(new LogHelper$OutputEnity(Objects.requireNonNull(logHelper$Output, "output"), outputTypes));
    }

    public static void addOutput(Path path) {
        LogHelper.addOutput(IOHelper.newWriter(path, true));
    }

    public static void addOutput(Writer writer) {
        LogHelper.addOutput(new SimpleLogHelperImpl$WriterOutput(writer), LogHelper$OutputTypes.PLAIN);
    }

    public static void debug(String string) {
        if (LogHelper.isDebugEnabled()) {
            LogHelper.log(LogHelper$Level.DEBUG, string, false);
        }
    }

    public static void dev(String string) {
        if (LogHelper.isDevEnabled()) {
            LogHelper.log(LogHelper$Level.DEV, string, false);
        }
    }

    public static void debug(String string, Object ... objectArray) {
        LogHelper.debug(String.format(string, objectArray));
    }

    public static void dev(String string, Object ... objectArray) {
        if (LogHelper.isDevEnabled()) {
            LogHelper.dev(String.format(string, objectArray));
        }
    }

    public static void error(Throwable throwable) {
        EXCEPTIONS_CALLBACKS.forEach(consumer -> consumer.accept(throwable));
        LogHelper.error(LogHelper.isStacktraceEnabled() ? LogHelper.toString(throwable) : throwable.toString());
    }

    public static void error(String string) {
        LogHelper.log(LogHelper$Level.ERROR, string, false);
    }

    public static void error(String string, Object ... objectArray) {
        LogHelper.error(String.format(string, objectArray));
    }

    public static void info(String string) {
        LogHelper.log(LogHelper$Level.INFO, string, false);
    }

    public static void info(String string, Object ... objectArray) {
        LogHelper.info(String.format(string, objectArray));
    }

    public static boolean isDebugEnabled() {
        return impl.isDebugEnabled();
    }

    public static void setDebugEnabled(boolean bl) {
        impl.setDebugEnabled(bl);
    }

    public static boolean isStacktraceEnabled() {
        return impl.isStacktraceEnabled();
    }

    public static void setStacktraceEnabled(boolean bl) {
        impl.setStacktraceEnabled(bl);
    }

    public static boolean isDevEnabled() {
        return impl.isDevEnabled();
    }

    public static void setDevEnabled(boolean bl) {
        impl.setDevEnabled(bl);
    }

    public static void log(LogHelper$Level logHelper$Level, String string, boolean bl) {
        impl.log(logHelper$Level, string, bl);
    }

    public static void logJAnsi(LogHelper$Level logHelper$Level, Supplier<String> supplier, Supplier<String> supplier2, boolean bl) {
        impl.logJAnsi(logHelper$Level, supplier, supplier2, bl);
    }

    public static void printVersion(String string) {
        impl.printVersion(string);
    }

    public static void printLicense(String string) {
        impl.printLicense(string);
    }

    public static boolean removeOutput(LogHelper$OutputEnity logHelper$OutputEnity) {
        return impl.removeOutput(logHelper$OutputEnity);
    }

    public static void subDebug(String string) {
        if (LogHelper.isDebugEnabled()) {
            LogHelper.log(LogHelper$Level.DEBUG, string, true);
        }
    }

    public static void subDebug(String string, Object ... objectArray) {
        LogHelper.subDebug(String.format(string, objectArray));
    }

    public static void subInfo(String string) {
        LogHelper.log(LogHelper$Level.INFO, string, true);
    }

    public static void subInfo(String string, Object ... objectArray) {
        LogHelper.subInfo(String.format(string, objectArray));
    }

    public static void subWarning(String string) {
        LogHelper.log(LogHelper$Level.WARNING, string, true);
    }

    public static void subWarning(String string, Object ... objectArray) {
        LogHelper.subWarning(String.format(string, objectArray));
    }

    public static String toString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void warning(String string) {
        LogHelper.log(LogHelper$Level.WARNING, string, false);
    }

    public static void warning(String string, Object ... objectArray) {
        LogHelper.warning(String.format(string, objectArray));
    }

    static {
        boolean bl = false;
        try {
            Class.forName("org.slf4j.Logger", false, LogHelper.class.getClassLoader());
            bl = Boolean.getBoolean(SLF4J_PROPERTY);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        impl = bl ? new Slf4jLogHelperImpl() : new SimpleLogHelperImpl();
    }
}

