/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.software.os.ApplicationInfo;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

public final class MacInstalledApps {
    private static final String COLON = ":";

    private MacInstalledApps() {
    }

    public static List<ApplicationInfo> queryInstalledApps() {
        List<String> list = ExecutingCommand.runNative("system_profiler SPApplicationsDataType");
        return MacInstalledApps.parseMacAppInfo(list);
    }

    private static List<ApplicationInfo> parseMacAppInfo(List<String> list) {
        ArrayList<ApplicationInfo> arrayList = new ArrayList<ApplicationInfo>();
        String string = null;
        HashMap<String, String> hashMap = null;
        boolean bl = false;
        for (String string2 : list) {
            if ((string2 = string2.trim()).endsWith(COLON)) {
                if (string != null && !hashMap.isEmpty()) {
                    arrayList.add(MacInstalledApps.createAppInfo(string, (Map<String, String>)hashMap));
                }
                string = string2.substring(0, string2.length() - 1);
                hashMap = new HashMap<String, String>();
                bl = true;
                continue;
            }
            if (!bl || !string2.contains(COLON)) continue;
            int n = string2.indexOf(COLON);
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            hashMap.put(string3, string4);
        }
        return arrayList;
    }

    private static ApplicationInfo createAppInfo(String string, Map<String, String> map) {
        String string2 = ParseUtil.getValueOrUnknown(map, "Obtained from");
        String string3 = ParseUtil.getValueOrUnknown(map, "Signed by");
        String string4 = string2.equals("Identified Developer") ? string3 : string2;
        String string5 = map.getOrDefault("Last Modified", "unknown");
        long l = ParseUtil.parseDateToEpoch(string5, "dd/MM/yy, HH:mm");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Kind", ParseUtil.getValueOrUnknown(map, "Kind"));
        hashMap.put("Location", ParseUtil.getValueOrUnknown(map, "Location"));
        hashMap.put("Get Info String", ParseUtil.getValueOrUnknown(map, "Get Info String"));
        return new ApplicationInfo(string, ParseUtil.getValueOrUnknown(map, "Version"), string4, l, hashMap);
    }
}

