/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.linux.proc.ProcessStat;
import oshi.software.common.AbstractInternetProtocolStats;
import oshi.software.os.InternetProtocolStats;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;
import oshi.util.tuples.Pair;

@ThreadSafe
public class LinuxInternetProtocolStats
extends AbstractInternetProtocolStats {
    private final String tcpColon = "Tcp:";
    private final String udpColon = "Udp:";
    private final String udp6 = "Udp6";

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        byte[] byArray = FileUtil.readAllBytes(ProcPath.SNMP, true);
        List<String> list = ParseUtil.parseByteArrayToStrings(byArray);
        EnumMap<TcpStat, Long> enumMap = new EnumMap<TcpStat, Long>(TcpStat.class);
        for (int i = 0; i < list.size() - 1; i += 2) {
            if (!list.get(i).startsWith("Tcp:") || !list.get(i + 1).startsWith("Tcp:")) continue;
            Map<TcpStat, String> map = ParseUtil.stringToEnumMap(TcpStat.class, list.get(i + 1).substring("Tcp:".length()).trim(), ' ');
            for (Map.Entry<TcpStat, String> entry : map.entrySet()) {
                enumMap.put(entry.getKey(), ParseUtil.parseLongOrDefault(entry.getValue(), 0L));
            }
            break;
        }
        return new InternetProtocolStats.TcpStats(enumMap.getOrDefault((Object)TcpStat.CurrEstab, 0L), enumMap.getOrDefault((Object)TcpStat.ActiveOpens, 0L), enumMap.getOrDefault((Object)TcpStat.PassiveOpens, 0L), enumMap.getOrDefault((Object)TcpStat.AttemptFails, 0L), enumMap.getOrDefault((Object)TcpStat.EstabResets, 0L), enumMap.getOrDefault((Object)TcpStat.OutSegs, 0L), enumMap.getOrDefault((Object)TcpStat.InSegs, 0L), enumMap.getOrDefault((Object)TcpStat.RetransSegs, 0L), enumMap.getOrDefault((Object)TcpStat.InErrs, 0L), enumMap.getOrDefault((Object)TcpStat.OutRsts, 0L));
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        byte[] byArray = FileUtil.readAllBytes(ProcPath.SNMP, true);
        List<String> list = ParseUtil.parseByteArrayToStrings(byArray);
        EnumMap<UdpStat, Long> enumMap = new EnumMap<UdpStat, Long>(UdpStat.class);
        for (int i = 0; i < list.size() - 1; i += 2) {
            if (!list.get(i).startsWith("Udp:") || !list.get(i + 1).startsWith("Udp:")) continue;
            Map<UdpStat, String> map = ParseUtil.stringToEnumMap(UdpStat.class, list.get(i + 1).substring("Udp:".length()).trim(), ' ');
            for (Map.Entry<UdpStat, String> entry : map.entrySet()) {
                enumMap.put(entry.getKey(), ParseUtil.parseLongOrDefault(entry.getValue(), 0L));
            }
            break;
        }
        return new InternetProtocolStats.UdpStats(enumMap.getOrDefault((Object)UdpStat.OutDatagrams, 0L), enumMap.getOrDefault((Object)UdpStat.InDatagrams, 0L), enumMap.getOrDefault((Object)UdpStat.NoPorts, 0L), enumMap.getOrDefault((Object)UdpStat.InErrors, 0L));
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        byte[] byArray = FileUtil.readAllBytes(ProcPath.SNMP6, true);
        List<String> list = ParseUtil.parseByteArrayToStrings(byArray);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n = 0;
        block12: for (int i = list.size() - 1; i >= 0 && n < 4; --i) {
            if (!list.get(i).startsWith("Udp6")) continue;
            String[] stringArray = list.get(i).split("\\s+");
            switch (stringArray[0]) {
                case "Udp6InDatagrams": {
                    l = ParseUtil.parseLongOrDefault(stringArray[1], 0L);
                    ++n;
                    continue block12;
                }
                case "Udp6NoPorts": {
                    l2 = ParseUtil.parseLongOrDefault(stringArray[1], 0L);
                    ++n;
                    continue block12;
                }
                case "Udp6InErrors": {
                    l3 = ParseUtil.parseLongOrDefault(stringArray[1], 0L);
                    ++n;
                    continue block12;
                }
                case "Udp6OutDatagrams": {
                    l4 = ParseUtil.parseLongOrDefault(stringArray[1], 0L);
                    ++n;
                    continue block12;
                }
            }
        }
        return new InternetProtocolStats.UdpStats(l, l2, l3, l4);
    }

    @Override
    public List<InternetProtocolStats.IPConnection> getConnections() {
        ArrayList<InternetProtocolStats.IPConnection> arrayList = new ArrayList<InternetProtocolStats.IPConnection>();
        Map<Long, Integer> map = ProcessStat.querySocketToPidMap();
        arrayList.addAll(LinuxInternetProtocolStats.queryConnections("tcp", 4, map));
        arrayList.addAll(LinuxInternetProtocolStats.queryConnections("tcp", 6, map));
        arrayList.addAll(LinuxInternetProtocolStats.queryConnections("udp", 4, map));
        arrayList.addAll(LinuxInternetProtocolStats.queryConnections("udp", 6, map));
        return arrayList;
    }

    private static List<InternetProtocolStats.IPConnection> queryConnections(String string, int n, Map<Long, Integer> map) {
        ArrayList<InternetProtocolStats.IPConnection> arrayList = new ArrayList<InternetProtocolStats.IPConnection>();
        for (String string2 : FileUtil.readFile(ProcPath.NET + "/" + string + (n == 6 ? "6" : ""))) {
            String[] stringArray;
            if (string2.indexOf(58) < 0 || (stringArray = ParseUtil.whitespaces.split(string2.trim())).length <= 9) continue;
            Pair<byte[], Integer> pair = LinuxInternetProtocolStats.parseIpAddr(stringArray[1]);
            Pair<byte[], Integer> pair2 = LinuxInternetProtocolStats.parseIpAddr(stringArray[2]);
            InternetProtocolStats.TcpState tcpState = LinuxInternetProtocolStats.stateLookup(ParseUtil.hexStringToInt(stringArray[3], 0));
            Pair<Integer, Integer> pair3 = LinuxInternetProtocolStats.parseHexColonHex(stringArray[4]);
            long l = ParseUtil.parseLongOrDefault(stringArray[9], 0L);
            arrayList.add(new InternetProtocolStats.IPConnection(string + n, pair.getA(), pair.getB(), pair2.getA(), pair2.getB(), tcpState, pair3.getA(), pair3.getB(), map.getOrDefault(l, -1)));
        }
        return arrayList;
    }

    private static Pair<byte[], Integer> parseIpAddr(String string) {
        int n = string.indexOf(58);
        if (n > 0 && n < string.length()) {
            byte[] byArray = ParseUtil.hexStringToByteArray(string.substring(0, n));
            int n2 = 0;
            while (n2 + 3 < byArray.length) {
                byte by = byArray[n2];
                byArray[n2] = byArray[n2 + 3];
                byArray[n2 + 3] = by;
                by = byArray[n2 + 1];
                byArray[n2 + 1] = byArray[n2 + 2];
                byArray[n2 + 2] = by;
                n2 += 4;
            }
            n2 = ParseUtil.hexStringToInt(string.substring(n + 1), 0);
            return new Pair<byte[], Integer>(byArray, n2);
        }
        return new Pair<byte[], Integer>(new byte[0], 0);
    }

    private static Pair<Integer, Integer> parseHexColonHex(String string) {
        int n = string.indexOf(58);
        if (n > 0 && n < string.length()) {
            int n2 = ParseUtil.hexStringToInt(string.substring(0, n), 0);
            int n3 = ParseUtil.hexStringToInt(string.substring(n + 1), 0);
            return new Pair<Integer, Integer>(n2, n3);
        }
        return new Pair<Integer, Integer>(0, 0);
    }

    private static InternetProtocolStats.TcpState stateLookup(int n) {
        switch (n) {
            case 1: {
                return InternetProtocolStats.TcpState.ESTABLISHED;
            }
            case 2: {
                return InternetProtocolStats.TcpState.SYN_SENT;
            }
            case 3: {
                return InternetProtocolStats.TcpState.SYN_RECV;
            }
            case 4: {
                return InternetProtocolStats.TcpState.FIN_WAIT_1;
            }
            case 5: {
                return InternetProtocolStats.TcpState.FIN_WAIT_2;
            }
            case 6: {
                return InternetProtocolStats.TcpState.TIME_WAIT;
            }
            case 7: {
                return InternetProtocolStats.TcpState.CLOSED;
            }
            case 8: {
                return InternetProtocolStats.TcpState.CLOSE_WAIT;
            }
            case 9: {
                return InternetProtocolStats.TcpState.LAST_ACK;
            }
            case 10: {
                return InternetProtocolStats.TcpState.LISTEN;
            }
            case 11: {
                return InternetProtocolStats.TcpState.CLOSING;
            }
        }
        return InternetProtocolStats.TcpState.UNKNOWN;
    }

    private static enum TcpStat {
        RtoAlgorithm,
        RtoMin,
        RtoMax,
        MaxConn,
        ActiveOpens,
        PassiveOpens,
        AttemptFails,
        EstabResets,
        CurrEstab,
        InSegs,
        OutSegs,
        RetransSegs,
        InErrs,
        OutRsts,
        InCsumErrors;

    }

    private static enum UdpStat {
        OutDatagrams,
        InDatagrams,
        NoPorts,
        InErrors,
        RcvbufErrors,
        SndbufErrors,
        InCsumErrors,
        IgnoredMulti,
        MemErrors;

    }
}

